/*
 * Decompiled with CFR 0.152.
 */
package de.DroolsGUI;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import de.DroolsGUI.DroolsGUIModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DroolsGUIView
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DroolsGUIModel model = new DroolsGUIModel();
    private JTextArea jTextArea_OutputArea;
    private JLabel jLabel_step3;
    private JLabel jLabel_step2;
    private JLabel jLabel_step1;
    private JButton jButton_clearConsole;
    private JButton jButton_removeAllInput;
    private JButton jButton_errorCheck;
    private JScrollPane jScrollPane_OutputArea;
    private JButton jButton_FireAllRules;
    private JButton jButton_DRLInput;
    private JLabel jLabel_Output;

    public DroolsGUIView() {
        this.setOpaque(true);
        this.initGUI();
        this.setOutputStream();
        this.setErrorStream();
    }

    private void initGUI() {
        try {
            AnchorLayout thisLayout = new AnchorLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(584, 420));
            this.jLabel_step3 = new JLabel();
            this.add((Component)this.jLabel_step3, new AnchorConstraint(194, 607, 232, 375, 1, 1, 1, 1));
            this.jLabel_step3.setText("Step 3:");
            this.jLabel_step3.setPreferredSize(new Dimension(135, 16));
            this.jLabel_step3.setHorizontalAlignment(4);
            this.jLabel_step3.setForeground(new Color(0, 128, 0));
            this.jLabel_step2 = new JLabel();
            this.add((Component)this.jLabel_step2, new AnchorConstraint(122, 607, 160, 375, 1, 1, 1, 1));
            this.jLabel_step2.setText("Step 2:");
            this.jLabel_step2.setPreferredSize(new Dimension(135, 16));
            this.jLabel_step2.setHorizontalAlignment(4);
            this.jLabel_step2.setForeground(new Color(228, 202, 16));
            this.jLabel_step1 = new JLabel();
            this.add((Component)this.jLabel_step1, new AnchorConstraint(53, 608, 91, 375, 1, 1, 1, 1));
            this.jLabel_step1.setText("Step 1:");
            this.jLabel_step1.setPreferredSize(new Dimension(136, 16));
            this.jLabel_step1.setHorizontalAlignment(4);
            this.jLabel_step1.setForeground(new Color(255, 0, 0));
            this.jTextArea_OutputArea = new JTextArea();
            this.jTextArea_OutputArea.setEditable(false);
            this.jTextArea_OutputArea.setFont(new Font("Serif", 0, 12));
            this.jTextArea_OutputArea.setLineWrap(true);
            this.jTextArea_OutputArea.setWrapStyleWord(true);
            this.jScrollPane_OutputArea = new JScrollPane(this.jTextArea_OutputArea);
            this.jScrollPane_OutputArea.setVerticalScrollBarPolicy(20);
            this.add((Component)this.jScrollPane_OutputArea, new AnchorConstraint(298, 980, 972, 21, 1, 1, 1, 1));
            this.jLabel_Output = new JLabel();
            this.add((Component)this.jLabel_Output, new AnchorConstraint(232, 471, 270, 21, 1, 1, 1, 1));
            this.jLabel_Output.setText("Ausgabefenster:");
            this.jLabel_Output.setPreferredSize(new Dimension(263, 16));
            this.jLabel_Output.setHorizontalAlignment(2);
            this.jButton_DRLInput = new JButton();
            this.add((Component)this.jButton_DRLInput, new AnchorConstraint(44, 951, 103, 629, 1, 1, 1, 1));
            this.jButton_DRLInput.setText(".drl File Input");
            this.jButton_DRLInput.setPreferredSize(new Dimension(188, 25));
            this.jButton_DRLInput.setToolTipText("Geben Sie eine oder mehrere Drools Rule Files (.drl) an");
            this.jButton_DRLInput.addActionListener(this);
            this.jButton_FireAllRules = new JButton();
            this.add((Component)this.jButton_FireAllRules, new AnchorConstraint(184, 951, 244, 629, 1, 1, 1, 1));
            this.jButton_FireAllRules.setText("Fire all Rules");
            this.jButton_FireAllRules.setPreferredSize(new Dimension(188, 25));
            this.jButton_FireAllRules.setEnabled(false);
            this.jButton_FireAllRules.setToolTipText("Feuert alle Regeln die zutreffen");
            this.jButton_FireAllRules.addActionListener(this);
            this.jButton_errorCheck = new JButton();
            this.add((Component)this.jButton_errorCheck, new AnchorConstraint(113, 951, 172, 629, 1, 1, 1, 1));
            this.jButton_errorCheck.setText("Check for Compile Errors");
            this.jButton_errorCheck.setPreferredSize(new Dimension(188, 25));
            this.jButton_errorCheck.setEnabled(false);
            this.jButton_errorCheck.setToolTipText("Testet die eingegebenen Dateien auf Compiler Fehler und zeigt diese im Ausgabefenster an falls vorhanden");
            this.jButton_errorCheck.addActionListener(this);
            this.jButton_clearConsole = new JButton();
            this.add((Component)this.jButton_clearConsole, new AnchorConstraint(113, 322, 172, 21, 1, 1, 1, 1));
            this.jButton_clearConsole.setText("Ausgabefenster leeren");
            this.jButton_clearConsole.setToolTipText("Entfernt den Text aus dem Ausgabefenster");
            this.jButton_clearConsole.setPreferredSize(new Dimension(176, 25));
            this.jButton_clearConsole.addActionListener(this);
            this.jButton_removeAllInput = new JButton();
            this.add((Component)this.jButton_removeAllInput, new AnchorConstraint(44, 322, 103, 21, 1, 1, 1, 1));
            this.jButton_removeAllInput.setText("Remove all Input");
            this.jButton_removeAllInput.setPreferredSize(new Dimension(176, 25));
            this.jButton_removeAllInput.setToolTipText("Entfernt alle eingegebenen Dateien");
            this.jButton_removeAllInput.setEnabled(false);
            this.jButton_removeAllInput.addActionListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.jButton_FireAllRules)) {
            this.model.fireRules();
        }
        if (e.getSource().equals(this.jButton_DRLInput)) {
            JFileChooser fc = new JFileChooser();
            JDialog dialogFile = new JDialog();
            dialogFile.setLayout(null);
            dialogFile.setSize(400, 300);
            fc.showOpenDialog(dialogFile);
            try {
                System.out.println("Selected File: " + fc.getSelectedFile().getPath());
                this.model.addKnowledgeToBuilder(fc.getSelectedFile().getPath());
                this.jButton_errorCheck.setEnabled(true);
                this.jButton_removeAllInput.setEnabled(true);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (e.getSource().equals(this.jButton_errorCheck) && !this.model.errorCheck()) {
            this.jButton_FireAllRules.setEnabled(true);
            DroolsGUIModel.createKnowledgeBase();
            System.out.println("Kein Compiler Error!");
        }
        if (e.getSource().equals(this.jButton_clearConsole)) {
            this.jTextArea_OutputArea.setText("");
        }
        if (e.getSource().equals(this.jButton_removeAllInput)) {
            this.jButton_removeAllInput.setEnabled(false);
            this.jButton_FireAllRules.setEnabled(false);
            this.jButton_errorCheck.setEnabled(false);
            this.model.removeAllInput();
        }
    }

    public void newStringToTextArea(String str, boolean newline) {
        if (newline) {
            this.jTextArea_OutputArea.append(String.valueOf(str) + "\n");
        } else {
            this.jTextArea_OutputArea.append(str);
        }
    }

    public void setOutputStream() {
        PrintStream myOutStream = new PrintStream(System.out){

            @Override
            public void println(String s) {
                DroolsGUIView.this.newStringToTextArea(s, true);
            }

            @Override
            public void print(String s) {
                DroolsGUIView.this.newStringToTextArea(s, false);
            }
        };
        System.setOut(myOutStream);
    }

    public void setErrorStream() {
        PrintStream myErrStream = new PrintStream(System.err){

            @Override
            public void println(String s) {
                DroolsGUIView.this.newStringToTextArea(s, true);
            }

            @Override
            public void print(String s) {
                DroolsGUIView.this.newStringToTextArea(String.valueOf(s) + "\n", false);
            }
        };
        System.setErr(myErrStream);
    }
}

